/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010
*  ALL RIGHTS RESERVED
*
*  File Name:   MMA7660.c
*                                                                          
*  Description: C Source for MMA7660 Acelerometer 
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.1
*                                            
*  Version:     1.0                                                         
*                                                                                                                                                         
*  Author:      Santiago Lopez [SL](SSE Americas)
*               Martin Bricchi [MB](SSE Americas)
*                                                                                     
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR   DESCRIPTION OF CHANGE
* ---   ----------  ------   --------------------- 
* 1.0   2010.11.08   SL/MB      Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "MMA7660.h"

/*****************************************************************************/
/*                                Functions
/*****************************************************************************/
  
  void vfnMMA7660Init (void)
  {  
   vfnMMA7660Write (MMA7660_Mode,0x00);          //Stops the MMA7660 for configuration
   vfnMMA7660Write (MMA7660_SR,0x02);            //32 SPS without Filteringv
   vfnMMA7660Write (MMA7660_INTSU,0x10);         //Enables Interrupts each axis update
   vfnMMA7660Write (MMA7660_Mode,0x11);          //Run mode*/  
  } 
 
/*****************************************************************************/
  
  void vfnMMA7660Write (UINT8 RegisterAdd, UINT8 Data) 
  {
   UINT8 IICBuffer[2];
   
   IICBuffer[0]=RegisterAdd;
   IICBuffer[1]=Data;
   vfnIICV1Write(MMA7660_Slave_Address,&IICBuffer[0],sizeof(IICBuffer));
   
   while(IICV1_BUSY)
   {
    vfnapIICV1Driver[gu8IICV1ActualState]();
   }
  } 
  
/*****************************************************************************/
  
  UINT8 MMA7660Read (UINT8 RegisterAdd)
  {
   UINT8 Data;
   
   Data=RegisterAdd;
   
   vfnIICV1RandomRead(MMA7660_Slave_Address,&Data,(UINT8)1,&Data,(UINT8)1);
   
   while(IICV1_BUSY)
   {
    vfnapIICV1Driver[gu8IICV1ActualState]();
   }
     
   return Data;
  } 
  
/*****************************************************************************/
 
 void interrupt VectorNumber_Virq MMA7660_Interrupt (void)
{
 IRQSC_IRQACK = 1;
 MMA7660_InterruptSucceded = True;
} 